; Logier's Annual 2024 Christmas Present coding compeition.
; Submission for the VZ200/VZ300 and Laser210/Laser310 computers.
; -Dave / Bushy555.
;
; Execution assumptions:
; Memory is initially blank from $8000 to $8078.
; (First program to run immediately after emulator is ran)
;
; Binary Snapshot
; ---------------
;  24 bytes :  snapshot header. Not included in the source.
;  84 bytes :  code
; 108 bytes :  total file size.
; 268 bytes :  source size.
;
; Assemble with PASMO.EXE Z80 assembler.
; PASMO --alocal file.asm file.obj
; RBINARY file.obj file.VZ
;
; RBINARY is a VZ/Laser special windows command-line 'linker' utility that adds the 24 byte snapshot 
; header on to the object code, and creates the output .VZ snapshot to load into an emulator.
; Further "VZ2WAV" utilties allow for the snapshot to be turned into a PCM 8-bit WAV that 
; can then be loaded into a real physical Laser or VZ computer.
; RBINARY executable and numerous VZ2WAV utilities can be found at : www.vz200.org/bushy
; The RBINARY util simulates the below commented out header file.
;


;	org	$8000-24		; Originate the snapshot in memory at $7FE8
;	db	'VZF1'			; HEADER: vzmagic       [04].  Can essentially be anything. This is the default.
;	db	'FILENAME         '     ; HEADER: filename      [17].  Includes the capture of a line feed at keyboard entry, hence 17.
;	db	$F1			; HEADER: Filetype      [01].  $F1 = Machine Language. NOT BASIC.
;	dw	$8000			; HEADER: Start address [02].  Typical start is at $7B00 or $8000.
;									Start of program in RAM.


	org	$8000			; originate at memory location $8000.

	call	$1C9			; CLS ROM
	ld	hl, d1			; Select Line 1 to display
	ld	de, $7008		; Position 9, top row in Video ram.
	ld	bc, 3			; 3 Characters of the ribbon to dispay.
	ldir				; display the ribbon. (Move 3 chars from Line 1 to video ram)
	
					; Display line 2.  Register HL already pointing to line 2 'e1' coz its after line 1 'd1'
	call	$2B75			; Call ROM routine to display the line pointed to by HL. Zero Byte delimiter is end of message.

	ld	e, 2			; Use register E as a two-loop counter. 
a1:	ld	b, 8			; Set register B as counter in order to display Line 3 eight times.
b1:	ld	hl, f1			; Select Line 3 to display.
	call	$2B75			; Call ROM routine to display the line pointed to by HL. Byte 0 is end of display.
	djnz	b1			; Loop back for another go.  Two loops.  Reduces register B and jumps back to label 'b1'

	ld	hl, e1			; Select line 2 to display within the two counter loop.
	call	$2B75			; Call ROM routine to display the line pointed to by HL. Byte 0 is end of display.

	dec	e			; Outer two counter loop. Reduces register from 2 to 1.
	jr	nz, a1			; Jumps if zero flag is not yet set. Ie, if register E is still 2 or 1. Will drop thru when E=0.

c1: 	jr	c1			; Forever loop to show screen. The opcode HALT doesnt work very well on the VZ/Laser.


d1: db '\O',111				; Line 1 : Ribbon. 
e1: db $d,'+--------+--------+',0	; Line 2 : Top and middle and bottom of the Christmas present box.
f1: db $d,'!        !        !'		; Line 3 : in between bits of the Christmas present box.







;
;        \O/
;+--------+--------+
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;+--------+--------+
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;+--------+--------+
;




                                                                                        
                                             
                                                                                      


                                                            
                                                                                        